/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.BadPacketException;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.PacketTraceType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PacketTrace
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 8;
    protected Vector<Packet> packetVector;
    protected Vector<Packet> filteredVector;
    protected boolean changed;
    protected PacketTraceType traceType;

    public PacketTrace() {
        this.packetVector = new Vector();
        this.filteredVector = new Vector();
        this.clear();
    }

    public static PacketTraceType getTraceType(ObjectInput objectInput) throws ClassNotFoundException, IOException, BadPacketException {
        objectInput.readInt();
        objectInput.readInt();
        int n = objectInput.readInt();
        PacketTraceType packetTraceType = PacketTraceType.UNDEFINED_PACKET_TRACE_TYPE;
        for (int i = 0; i < n && packetTraceType == PacketTraceType.UNDEFINED_PACKET_TRACE_TYPE; ++i) {
            Packet packet = (Packet)objectInput.readObject();
            if (packet.getSource() == 6) {
                packetTraceType = PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE;
                continue;
            }
            if (packet.getSource() == 2) {
                packetTraceType = PacketTraceType.HDMI_PACKET_TRACE_TYPE;
                continue;
            }
            if (packet.getSource() != 1) continue;
            packetTraceType = PacketTraceType.HDMI_PACKET_TRACE_TYPE;
        }
        return packetTraceType;
    }

    public PacketTrace(ObjectInput objectInput) throws ClassNotFoundException, IOException, BadPacketException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = 28;
        int n4 = n * 10 + n2;
        if (n4 > n3) {
            String string = "File Version " + n + "." + n2 + " Incompatible with Program Version " + 2 + "." + 8;
            throw new BadPacketException(string);
        }
        int n5 = objectInput.readInt();
        Vector<Packet> vector = new Vector<Packet>();
        I2CDataBlock.resetParser();
        CECDataBlock.resetParser();
        DisplayPortDataBlock.resetParser();
        for (int i = 0; i < n5; ++i) {
            Object object = objectInput.readObject();
            if (!(object instanceof Packet)) {
                String string = "Whoa nelly!  Object " + i + " is not a Packet!";
                throw new BadPacketException(string);
            }
            vector.add((Packet)object);
        }
        this.clear();
        this.packetVector = vector;
        this.constructFilteredVector();
    }

    public void writeTrace(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(2);
        objectOutput.writeInt(8);
        int n = this.packetVector.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.packetVector.get(i));
        }
    }

    public synchronized Packet getPacket(int n) {
        return this.filteredVector.get(n);
    }

    public synchronized void clear() {
        if (this.packetVector != null) {
            this.packetVector.clear();
        }
        if (this.filteredVector != null) {
            this.filteredVector.clear();
        }
        this.packetVector = new Vector();
        this.filteredVector = new Vector();
        this.changed = false;
        this.refresh();
    }

    public PacketTraceType GetPacketTraceType() {
        return this.traceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Packet packet) {
        PacketTrace packetTrace = this;
        synchronized (packetTrace) {
            this.packetVector.add(packet);
            if (MainAppFrame.togglePauseAction.getValue("actionConstants.selected") == Boolean.FALSE) {
                if (this.filteredVector.size() > 0) {
                    this.addFilteredPacket(this.filteredVector.remove(this.filteredVector.size() - 1));
                }
                this.addFilteredPacket(packet);
            }
            this.changed = true;
            this.refresh();
        }
    }

    public void addPacketHT180(Packet packet) {
        this.packetVector.add(packet);
    }

    public void updateFilteredTrace() {
        this.constructFilteredVector();
    }

    public void refresh() {
        if (Sniffer.parser.isCapturing()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PacketTrace.this.fireTableDataChanged();
                }
            });
        } else {
            this.fireTableDataChanged();
        }
    }

    protected boolean addFilteredPacket(Packet packet) {
        boolean bl;
        if (!MainAppFrame.togglePedanticAction.isTrue()) {
            if (packet.dataBlock == null) {
                return false;
            }
            if (packet.getSource() != 6 && packet.isI2C() && ((I2CDataBlock)packet.dataBlock).getRawMessage() == null) {
                return false;
            }
            if (packet.isCEC() && ((CECDataBlock)packet.dataBlock).getRawMessage() == null) {
                return false;
            }
        }
        boolean bl2 = (bl = packet.isError()) || !MainAppFrame.errorsOnlyAction.isTrue();
        boolean bl3 = packet.isDDCCI() && MainAppFrame.filterDDCCIAction.isTrue();
        bl3 = bl3 || packet.isEDID() && MainAppFrame.filterEDIDAction.isTrue();
        bl3 = bl3 || packet.isEvent() && MainAppFrame.filterEventsAction.isTrue();
        bl3 = bl3 || packet.isHDCP() && MainAppFrame.filterHDCPAction.isTrue();
        bl3 = bl3 || packet.isLT() && MainAppFrame.filterLTAction.isTrue();
        bl3 = bl3 || packet.isCEC() && MainAppFrame.filterCECAction.isTrue();
        boolean bl4 = bl3 = bl3 || packet.isOther() && MainAppFrame.filterOtherAction.isTrue();
        if (bl2 && bl3) {
            this.filteredVector.add(packet);
            return true;
        }
        return false;
    }

    private synchronized void constructFilteredVector() {
        this.filteredVector.clear();
        this.filteredVector = new Vector();
        for (int i = 0; i < this.packetVector.size(); ++i) {
            this.addFilteredPacket(this.packetVector.get(i));
        }
        this.refresh();
    }

    @Override
    public int getRowCount() {
        return this.filteredVector.size();
    }

    public boolean tableChanged() {
        return this.changed;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getValueAt(n, n2, false);
    }

    public abstract Object getValueAt(int var1, int var2, boolean var3);

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public int getPacketCount() {
        return this.packetVector.size();
    }

    public int getFilteredCount() {
        return this.filteredVector.size();
    }

    public boolean needsSaving() {
        return this.tableChanged() && 1 == JOptionPane.showConfirmDialog(Sniffer.window, "Current trace has not been saved.  If you continue, any unsaved changes will be lost.  Do you want to proceed?", "Confirm Trace Save", 0, 2);
    }

    @Override
    public abstract int getColumnCount();

    public abstract String GetTimestampAsString(long var1);

    public abstract String GetTimestampAsString(Packet var1);

    public abstract String GetTimestampDifferenceAsString(Packet var1, Packet var2);

    public abstract void updateTimeColumnName(JTable var1);

    public abstract StringBuffer saveToHtml();

    public abstract String getNonHtmlColumnName(int var1);
}

